<?php
/**
 * mysql_compat.php
 * Compatibility layer for old mysql_* functions (PHP 5 → PHP 8)
 */

if (!function_exists('mysql_connect')) {

    // Global link
    if (!isset($GLOBALS['_MYSQL_CONN'])) {
        $GLOBALS['_MYSQL_CONN'] = null;
    }

    // Allow compatibility with existing mysqli connections
    function mysql_connect($host = null, $user = null, $pass = null) {
        $conn = @mysqli_connect($host, $user, $pass);
        $GLOBALS['_MYSQL_CONN'] = $conn;
        return $conn;
    }

    function mysql_select_db($dbname, $conn = null) {
        if (!$conn) $conn = $GLOBALS['_MYSQL_CONN'];
        if (!$conn) return false;
        return mysqli_select_db($conn, $dbname);
    }

    function mysql_query($query, $conn = null) {
        // fallback to global connection if null
        if (!$conn) {
            $conn = $GLOBALS['_MYSQL_CONN'];
            // if still null, try using $GLOBALS['oprmConn'] if set
            if (!$conn && isset($GLOBALS['oprmConn'])) {
                $conn = $GLOBALS['oprmConn'];
            }
        }
        if (!$conn) {
            trigger_error("mysql_query(): No active MySQL connection found", E_USER_WARNING);
            return false;
        }
        return mysqli_query($conn, $query);
    }

    function mysql_fetch_array($result, $type = MYSQLI_BOTH) {
        return mysqli_fetch_array($result, $type);
    }

    function mysql_fetch_assoc($result) {
        return mysqli_fetch_assoc($result);
    }

    function mysql_fetch_row($result) {
        return mysqli_fetch_row($result);
    }

    function mysql_num_rows($result) {
        return mysqli_num_rows($result);
    }

    function mysql_insert_id($conn = null) {
        if (!$conn) $conn = $GLOBALS['_MYSQL_CONN'] ?? $GLOBALS['oprmConn'] ?? null;
        return mysqli_insert_id($conn);
    }

    function mysql_real_escape_string($string, $conn = null) {
        if (!$conn) $conn = $GLOBALS['_MYSQL_CONN'] ?? $GLOBALS['oprmConn'] ?? null;
        return mysqli_real_escape_string($conn, $string);
    }

    function mysql_error($conn = null) {
        if (!$conn) $conn = $GLOBALS['_MYSQL_CONN'] ?? $GLOBALS['oprmConn'] ?? null;
        return mysqli_error($conn);
    }

    function mysql_close($conn = null) {
        if (!$conn) $conn = $GLOBALS['_MYSQL_CONN'] ?? $GLOBALS['oprmConn'] ?? null;
        return mysqli_close($conn);
    }
}
?>
