<?php
// registration.php - fixed for PHP 8+ and safer input handling

require_once('Connections/oprmConn.php');

// ensure sessions are started (header.php expects session vars)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// initialize variables to avoid undefined variable warnings
$msg = '';

// helper: safe access and escape for mysql_* usage
function post_val($key, $conn) {
    $val = $_POST[$key] ?? '';
    // trim and optionally escape for SQL
    if ($conn && function_exists('mysql_real_escape_string')) {
        return mysql_real_escape_string(trim($val), $conn);
    }
    return trim($val);
}

function req_val($key, $conn) {
    $val = $_REQUEST[$key] ?? '';
    if ($conn && function_exists('mysql_real_escape_string')) {
        return mysql_real_escape_string(trim($val), $conn);
    }
    return trim($val);
}

// Only process when form submitted
if (isset($_POST['fullname'])) {

    // safe input variables (escaped)
    $fullname = post_val('fullname', $oprmConn);
    $emailaddress = post_val('emailaddress', $oprmConn);
    $title = post_val('title', $oprmConn);
    $message = post_val('message', $oprmConn);

    // basic guard: require email and name (client-side exists, but server-side too)
    if ($fullname === '' || $emailaddress === '') {
        $msg = "Full name and Email are required.";
        header("Location: registration?errmsg=" . urlencode($msg));
        exit;
    }

    // check existing user
    mysql_select_db($database_oprmConn, $oprmConn);
    $query_getProj = "SELECT * FROM weby_users WHERE email_address = '$emailaddress' AND status IN ('A','P')";
    $getProj = mysql_query($query_getProj, $oprmConn) or die(mysql_error());
    $row_getProj = mysql_fetch_assoc($getProj);
    $totalRows_getProj = mysql_num_rows($getProj);

    if ($totalRows_getProj < 1) {

        // create user
        $date = date('Y-m-d H:i:s');
        $t = rand(12100, 99999);

        mysql_select_db($database_oprmConn, $oprmConn);
        $query_getProj1 = "INSERT INTO weby_users (`user_id`, `email_address`, `password`, `user_role`, `token`, `status`, `created_by`, `caeated_date`, `updated_by`, `updated_date`) VALUES (NULL, '$emailaddress', '', '2', '$t', 'P', '', '$date', '', CURRENT_TIMESTAMP)";
        $getProj1 = mysql_query($query_getProj1, $oprmConn) or die(mysql_error());

        // get last inserted user id (your DB uses max(user_id) pattern)
        mysql_select_db($database_oprmConn, $oprmConn);
        $query_getProj2 = "SELECT MAX(user_id) as uid FROM weby_users";
        $getProj2 = mysql_query($query_getProj2, $oprmConn) or die(mysql_error());
        $row_getProj2 = mysql_fetch_assoc($getProj2);
        $new_uid = $row_getProj2['uid'] ?? '';

        // get admin email (user_role = 1)
        mysql_select_db($database_oprmConn, $oprmConn);
        $query_getProj22 = "SELECT email_address FROM weby_users WHERE user_role = 1 LIMIT 1";
        $getProj22 = mysql_query($query_getProj22, $oprmConn) or die(mysql_error());
        $row_getProj22 = mysql_fetch_assoc($getProj22);
        $admin_notify_email = $row_getProj22['email_address'] ?? '';

        // insert profile (use safe title/message and $new_uid)
        $safe_fullname = $fullname;
        $safe_title = $title;
        $safe_message = $message;
        $safe_uid = mysql_real_escape_string($new_uid, $oprmConn);

        $q = "INSERT INTO weby_profiles (`full_name`, `job_title`, `skill_set`, `profile_pic`, `cv_file`, `passport_file`, `holiday_sheet`, `other_docs`, `other_info`, `bank_account`, `bank_sortcode`, `bank_address`, `passport_number`, `citizen_of`, `work_permit`, `contact_phone`, `contact_address`, `hr_rate`, `created_by`, `created_date`, `updated_by`, `updated_date`, `user_id`) VALUES (
            '$safe_fullname', '$safe_title', '$safe_message', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '$safe_uid', '', '', CURRENT_TIMESTAMP, '$safe_uid')";

        mysql_select_db($database_oprmConn, $oprmConn);
        $getProj3 = mysql_query($q, $oprmConn) or die(mysql_error());

        // assign projects (10 and 11)
        $credate = date('Y-m-d');
        mysql_select_db($database_oprmConn, $oprmConn);
        $query_getasspro1 = "INSERT INTO weby_users_projects (`project_id`, `user_id`, `status`, `created_date`) VALUES ('10', '$safe_uid', 'A', '$credate')";
        $getasspro = mysql_query($query_getasspro1, $oprmConn) or die(mysql_error());

        mysql_select_db($database_oprmConn, $oprmConn);
        $query_getasspro2 = "INSERT INTO weby_users_projects (`project_id`, `user_id`, `status`, `created_date`) VALUES ('11', '$safe_uid', 'A', '$credate')";
        $getasspro = mysql_query($query_getasspro2, $oprmConn) or die(mysql_error());

        // verify profile/user exists (select join)
        mysql_select_db($database_oprmConn, $oprmConn);
        $query_getPa = "SELECT weby_profiles.full_name, weby_users.user_id, weby_users.email_address FROM weby_users, weby_profiles WHERE weby_users.email_address = '$emailaddress' AND weby_profiles.user_id = weby_users.user_id";
        $getPa = mysql_query($query_getPa, $oprmConn) or die(mysql_error());
        $row_getPa = mysql_fetch_assoc($getPa);
        $totalRows_getPa = mysql_num_rows($getPa);

        if ($totalRows_getPa > 0) {

            // safe host / fallback
            $host = $_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? 'localhost');

            $l = 'http://' . $host . '/RM/change-password?token=' . urlencode($t) . '&user=' . urlencode($safe_uid);
            $ll = 'http://' . $host . '/RM/index';

            // send email to new user and admin
            $user_email = $emailaddress;
            $headers = 'MIME-Version: 1.0' . "\r\n";
            $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
            // $SERVER_EMAIL might be defined in your config; fallback to no-reply style if not
            $from = defined('SERVER_EMAIL') ? SERVER_EMAIL : 'no-reply@example.com';
            $headers .= "From: $from" . "\r\n";

            $subject1 = "AIT TECH LIMITED  - New Resource Account Created.";
            $subject = "AIT TECH LIMITED  - New Account Information.";
            $body = "Hi " . htmlspecialchars($fullname) . ",<br>Your account has been successfully created with us.<br>Please click the below link to setup your password. <br>
                <br>
                <a href='$l'>Password Setup link </a><br>
                <br>
                Copy paste the below link in your browser addressbar if above link is not working.<br>
                $l
                <br>
                <i>Your account is currently InActive. You will receive mail communication once your account is activated by admin</i>
                Thanks,<br>
                AIT TECH LIMITED ";

            $body1 = "Hi Admin,<br>New Resource account has been successfully created.<br>Please login into admin area to activate the user. <br>
                <br>
                <a href='$ll'>admin login </a><br>
                <br>
                <br>
                <i>Resource account is currently InActive.</i>
                Thanks,<br>
                AIT TECH LIMITED ";

            // send mails (use admin notify email if available)
            if (!empty($user_email)) {
                @mail($user_email, $subject, $body, $headers);
            }
            if (!empty($ADMIN_EMAIL)) {
                @mail($ADMIN_EMAIL, $subject1, $body1, $headers);
            } elseif (!empty($admin_notify_email)) {
                @mail($admin_notify_email, $subject1, $body1, $headers);
            }
        }

        // success - redirect and stop script
        $msg = "You have successfully registered with Us, Please check your email and activate your account";
        header("Location: registration?msg=s");
        exit;

    } else {
        // email exists
        $msg = "Email Already Exists.";
        header("Location: registration?errmsg=" . urlencode($msg));
        exit;
    }
}
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>AIT TECH LIMITED - Signup</title>
<link href="css/style.css" type="text/css" rel="stylesheet"/>
<script type="text/javascript">
function validateForm2() {	
	var fullname = document.getElementById('fullname').value;
	if((fullname == "")||(fullname == null)){
        alert("Please enter full name");
		return false;
	}	
	var emailaddress = document.getElementById('emailaddress').value;
	if((emailaddress == "")||(emailaddress == null)){
        alert("Please enter email address");	
	return false;
	}
	
	if (echeck(emailaddress)==false){
		return false;
	}

	var message = document.getElementById('message').value;
	if((message == "")||(message == null)){
	 alert("Please enter message");
	return false;
	}	
	var question = document.getElementById('question').value;
	if((question == "")||(question == null)){
	 alert("Please enter the sum of given two digits");
	return false;
	}
	var ans = document.getElementById('ans').value;
	if(question != ans){
	 alert("Wrong Answer. Please try one more time");
	return false;
	}
}

function echeck(str) {
		var at="@"
		var dot="."
		var lat=str.indexOf(at)
		var lstr=str.length
		var ldot=str.indexOf(dot)
		if (str.indexOf(at)==-1){
		    alert("Incorrect email address");
		   return false
		}
		if (str.indexOf(at)==-1 || str.indexOf(at)==0 || str.indexOf(at)==lstr){
		    alert("Incorrect email address");
		   return false
		}
		if (str.indexOf(dot)==-1 || str.indexOf(dot)==0 || str.indexOf(dot)==lstr){
		    alert("Incorrect email address");
		    return false
		}
		 if (str.indexOf(at,(lat+1))!=-1){
		     alert("Incorrect email address");
		    return false
		 }
		 if (str.substring(lat-1,lat)==dot || str.substring(lat+1,lat+2)==dot){
		    alert("Incorrect email address");
		    return false
		 }
		 if (str.indexOf(dot,(lat+2))==-1){
		    alert("Incorrect email address");
		    return false
		 }		
		 if (str.indexOf(" ")!=-1){
		    alert("Incorrect email address");
		    return false
		 }					
	}
	
</script>
<?php if(isset($_GET['errmsg'])) { ?>
 <script>alert("<?php echo htmlspecialchars($_GET['errmsg']); ?>");</script>
<?php } ?>

</head>

<body>
	<div class="wrapper">
   	  <?php  require_once('includes/header.php'); ?> 
        <div class="content_container">
            <div class="content_wrapper">
                <div class="tools_wrapper">
                    <?php if(isset($_REQUEST['msg'])) { if($_REQUEST['msg']=="s") echo "<div><font color='#428bca'>You have successfully registered with Us, Please check your email and activate your account.</font></div><br><br><a href='index'>Click here</a> to login"; } else { ?>
    <form method="post" class="login_form"  onSubmit="return validateForm2();">
	<?php echo htmlspecialchars($msg); ?>
      <div class="signup_wrap">
        <h3>Signup</h3>
        <div class="field_item clear_fix">
          <div class="label"><label >Full Name</label></div>
          <div class="input"><input name="fullname" id="fullname" class="fullname" type="text" size="35" /></div>
        </div>
        <div class="field_item clear_fix">
          <div class="label"><label>Email Address</label></div>
          <div class="input"><input name="emailaddress" id="emailaddress" type="text"  size="35" /></div>
        </div>
        <div class="field_item clear_fix">
          <div class="label"><label >Skill Set</label></div>
          <div class="input"><textarea rows="5" cols="27"  name="message" id="message" class="required"></textarea></div>
        </div>
       
        <div class="question">
				<?php $n1 = rand(1,10); $n2 = rand(1,10); echo $n1." + ".$n2; ?> = <input name="question" id="question" type="text"  size="8" />
				<input type="hidden" value="<?php echo $n1+$n2 ?>" name="ans" id="ans" /></div>
        <div class="action_butt">
            <input name="submit" id="submit" type="submit" class="signupbutton" value="Signup"  />
            <input name="cancel" id="cancel" type="button" value="Cancel" onclick="window.location= 'index'" />
            <span class="paragraph clear_fix">After verifying your details activation link and password setup link will be sent to your email address</span>
        </div>
      </div>
    </form>
   <?php  } ?>
                </div>
            </div>
        </div>
    </div>
    <?php  require_once('includes/footer.php'); ?> 
</body>
</html>
